function md=qmu(md,package,varargin)
%INPUT function md=qmu(md,package)
%Deal with coupled ISSM or Cielo/ Dakota runs, to do sensitivity analyses.

global ISSM_DIR;

% qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
qmudir ='qmu';
%  qmufile can not be changed unless cielo_ice_script.sh is also changed
qmufile='qmu';
ivar   =1;
iresp  =1;
imethod=1;
iparams=1;
runmpi =false;

%  process any extra input arguments

for i=1:2:nargin-2
    switch varargin{i}
        case 'qmudir'
            qmudir =varargin{i+1};
        case 'qmufile'
            qmufile=varargin{i+1};
        case 'ivar'
            ivar   =varargin{i+1};
        case 'iresp'
            iresp  =varargin{i+1};
        case 'imethod'
            imethod=varargin{i+1};
        case 'iparams'
            iparams=varargin{i+1};
        case 'overwrite'
            overwrite=varargin{i+1};
        case 'outfiles'
            outfiles =varargin{i+1};
        case 'rstfile'
            rstfile  =varargin{i+1};
        case 'rundakota'
            rundakota=varargin{i+1};
        case 'runmpi'
            runmpi =varargin{i+1};
            disp(sprintf('runmpi=%d',runmpi));
    end
end

%first create temporary directory in which we will work
if exist(qmudir,'dir')
    if ~exist('overwrite','var')
        overwrite=input(['Overwrite existing ''' qmudir ''' directory? Y/N [N]: '], 's');
    end
    if strncmpi(overwrite,'y',1)
        system(['rm -rf ' qmudir]);
%    else
%        error('Existing ''%s'' directory not overwritten.',qmudir);
    end
end
mkdir(qmudir)
cd(qmudir)
system('cp $ISSM_DIR/startup.m .');

%save our model in qmu so that it can be repeatedly used by Dakota.
save('Qmu.model','md')

%create m and in files for dakota
if (~isfield(md.qmu_params(iparams),'direct') || ...
    ~md.qmu_params(iparams).direct) && ...
   (~isfield(md.qmu_params(iparams),'analysis_driver') || ...
    isempty(md.qmu_params(iparams).analysis_driver))
    md.qmu_params(iparams).analysis_driver=[ISSM_DIR '/src/m/solutions/dakota/cielo_ice_script.sh'];
end
dakota_in_data(md.qmu_method(imethod),md.variables(ivar),md.responses(iresp),md.qmu_params(iparams),qmufile,package,md);

%  check for existence of results.out files to use
if exist('results.out.1','file') || exist('results.out.zip','file')
    if ~exist('outfiles','var')
        outfiles=input(['Use existing ''results.out'' files? Y/N [N]: '], 's');
    end
    if ~strncmpi(outfiles,'y',1)
        system('rm -f results.out.[1-9]*');
    else
        if exist('results.out.zip','file') && ~exist('results.out.1','file')
            display('Inflating ''results.out.zip'' file.');
            system('unzip -q results.out.zip');
        end
    end
end

%  check for existence of dakota.rst file to use
rstflag='';
if (~exist('outfiles','var') || ~strncmpi(outfiles,'y',1)) && ...
    exist('dakota.rst','file')
    if ~exist('rstfile','var')
        rstfiles=input(['Use existing ''dakota.rst'' file? Y/N [N]: '], 's');
    end
    if strncmpi(rstfiles,'y',1)
        system('rm -f results.out.[1-9]*');
        system('dakota_restart_util print dakota.rst | grep completed');
        rstflag=' -read_restart dakota.rst';
    end
end

%call dakota
if ~exist('rundakota','var')
    rundakota=input(['Run Dakota analysis ''' qmufile '''? Y/N [N]: '], 's');
end
if ~strncmpi(rundakota,'y',1)
    cd ..
    return
end

if ~runmpi
    system(['dakota -i ' qmufile '.in -o ' qmufile '.out -e ' qmufile '.err' rstflag]);
else
%  use 'mpd --ncpus=8 &' to initialize mpi and 'mpdringtest' to verify.
%  exporting MPIRUN_NPROCS sets mpi in dakota.
%    system('mpd --ncpus=8 &');
%    system('mpdringtest');
    system(['export MPIRUN_NPROCS=8;mpirun -np 4 dakota -i ' qmufile '.in -o ' qmufile '.out -e ' qmufile '.err' rstflag]);
end

%  check to see if dakota returned errors in the err file
fide=fopen([qmufile '.err'],'r');
fline=fgetl(fide);
if ischar(fline)
    while ischar(fline)
        disp(sprintf('%s',fline));
        fline=fgetl(fide);
    end
    status=fclose(fide);
    cd ../
    error(['Dakota returned error in ''' qmufile '.err'' file.  ''' qmudir ''' directory retained.'])
end
status=fclose(fide);

%parse inputs and results from dakota
[method,dvar,dresp_in]=dakota_in_parse([qmufile '.in']);
md.dakotaresults.method   =method;
md.dakotaresults.dvar     =dvar;
md.dakotaresults.dresp_in =dresp_in;

[method,dresp_out,scm,pcm,srcm,prcm]=dakota_out_parse([qmufile '.out']);
md.dakotaresults.dresp_out=dresp_out;
md.dakotaresults.scm      =scm;
md.dakotaresults.pcm      =pcm;
md.dakotaresults.srcm     =srcm;
md.dakotaresults.prcm     =prcm;

if exist('dakota_tabular.dat','file')
    [method,dresp_dat                  ]=dakota_out_parse('dakota_tabular.dat');
    md.dakotaresults.dresp_dat=dresp_dat;
end

%save input and output files into model
%md.dakotain =readfile([qmufile '.in']);
%md.dakotaout=readfile([qmufile '.out']);
%if exist('dakota_tabular.dat','file')
%	md.dakotadat=readfile('dakota_tabular.dat');
%end

%  move all the individual function evalutations into zip files
system('zip -mq params.in.zip params.in.[1-9]*');
system('zip -mq results.out.zip results.out.[1-9]*');
system('zip -mq matlab.out.zip matlab*.out.[1-9]*');

%get out of local directory and erase
cd ../
% system(['rm -rf ' qmudir]);
