/*!\file: steadystate_core.cpp
 * \brief: core of the steadystate solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void steadystate_core(FemModel* femmodel){

	/*intermediary: */
	int step; 

	/*parameters: */
	int verbose;
	int dim;
	int solution_type;
	
	/* recover parameters:*/
	femmodel->parameters->FindParam(&verbose,VerboseEnum); 
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*intialize counters: */
	step=1;

	for(;;){
	
		if(verbose)_printf_("%s%i\n","   computing temperature and velocity for step: ",step);
		thermal_core(femmodel);

		if(verbose)_printf_("%s\n","computing depth average temperature");
		InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,TemperatureEnum,TemperatureAverageEnum);
	
		if(verbose)_printf_("%s\n","computing new velocity");
		diagnostic_core(femmodel);

		if(verbose)_printf_("%s\n","checking velocity, temperature and pressure convergence");
		if (step>1) if(steadystateconvergence(femmodel))goto cleanup_and_return;
		
		if(verbose)_printf_("%s\n","saving velocity, temperature and pressure to check for convergence at next step");
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VxEnum,VxOldEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VyEnum,VyOldEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VzEnum,VzOldEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,PressureEnum,PressureOldEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum,TemperatureOldEnum);
		
		//increase counter
		step++;
	}

	cleanup_and_return:
	
	if(verbose)_printf_("saving results:\n");
	if(solution_type==SteadystateSolutionEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VyEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VzEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VelEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,PressureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,MeltingRateEnum);
	}
}
