function responses=SpawnCore(femmodel,variables,variabledescriptors,counter);
%SPAWNCORE - for Qmu analysis, using Dakota. Spawn the core solution.
%
%   Usage:
%      responses=SpawnCore(femmodel,variables,variabledescriptors)
%

%retrieve parameters
verbose=femmodel.parameters.Verbose;
responsedescriptors=femmodel.parameters.ResponseDescriptors; 
solution_type=femmodel.parameters.SolutionType;

displaystring(verbose,'%s%i',['   qmu iteration:'],counter);

%first update the inputs to the femmodel using the variables provided to us by dakota.
[femmodel.elements femmodel.loads]=InputUpdateFromDakota(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,femmodel.part,variables,variabledescriptors);

%now run the core solution
[dummy,dummy,solutioncore]=SolutionConfiguration(solution_type);
eval(['femmodel=' solutioncore '(femmodel);']);

%now process the results to get response function values
responses=zeros(numel(responsedescriptors),1);
for i=1:numel(responsedescriptors),
	descriptor=responsedescriptors{i};
	responses(i)=qmuresponse(femmodel,descriptor);
end
