/*\file InputUpdateFromDakota.c
*\brief: update inputs using dakota input variables
*/

#include "./InputUpdateFromDakota.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i;

	/*input datasets: */
	Elements*   elements=NULL;
	Nodes*      nodes=NULL;
	Vertices*   vertices=NULL;
	Loads*      loads=NULL;
	Materials*  materials=NULL;
	Parameters* parameters=NULL;
	double*     variables=NULL;
	char**      variables_descriptors=NULL;
	char*       string=NULL;
	int         stringlength;
	int         numvariables;
	mxArray*    pfield=NULL;
	Vec         partition=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromDakotaUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	FetchData(&partition,PARTITION);
	VecShift(partition,-1.0); //get partition onto "c" indexing
	/*dakota input: */
	FetchData(&variables,&numvariables,VARIABLES);

	variables_descriptors=(char**)xmalloc(numvariables*sizeof(char*));
	for(i=0;i<numvariables;i++){

		pfield=mxGetCell(VARIABLESDESCRIPTORS,i);
		stringlength = (mxGetM(pfield) * mxGetN(pfield) * sizeof(mxChar)) + 1 ;
		mxGetString(pfield,string,stringlength);

		variables_descriptors[i]=string;
	}

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromDakotax(elements,nodes,vertices,loads, materials,parameters,partition,variables,variables_descriptors,numvariables);

	/*write output datasets: */
	WriteData(ELEMENTS,elements);
	WriteData(LOADS,loads);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&partition);
	
	xfree((void**)&variables);
	for(i=0;i<numvariables;i++){
		char* string=variables_descriptors[i]; xfree((void**)&string);
	}
	xfree((void**)&variables_descriptors);

	/*end module: */
	MODULEEND();
}

void InputUpdateFromDakotaUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements loads] = %s(elements,nodes,vertices,loads,materials,parameters,variables,variables_descriptors);\n",__FUNCT__);
	_printf_("\n");
}
