/*\file EnumAsModelField.cpp:
* \brief: output string associated with enum, that corresponds  to a model field
* for example: ThicknessEnum corresponds to model field thickness
*              DragCoefficientEnum corresponds to model field drag
*/

#include "../shared/shared.h"
#include "../include/include.h"
#include "./EnumDefinitions.h"

char* EnumAsModelField(int en){

	switch(en){

		case ThicknessEnum : return "thickness";
		case DragCoefficientEnum : return "drag_coefficient";
		default : return "unknown";
	}
}
