/*!\file InputDepthAveragex
 * \brief: average field throfieldh thickness
 */

#include "./InputDepthAveragex.h"
#include "../InputExtrudex/InputExtrudex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputDepthAveragex( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int enum_type,int average_enum_type){
	
	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes   ->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*First depth-average inputs at base of the glacier*/
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->InputDepthAverageAtBase(enum_type,average_enum_type);
	}

	/*Then extrude vertically the new inputs*/
	InputExtrudex( elements,nodes,vertices,loads,materials,parameters,average_enum_type);
}
