function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE

%analysis_type: check on this option, error out otherwise
analysis_type=getfieldvalueerr(options,'analysis_type');

%sub_analysis_type: check on it, not mandatory
sub_analysis_type=getfieldvalue(options,'sub_analysis_type',NoneAnalysisEnum);

%batch mode for launching jobs.
outoptions.batch=getfieldvalue(options,'batch','no');

%directory 
outoptions.directory=getfieldvalue(options,'directory','');

%convert to Enum if a string was provided
if ischar(analysis_type),        analysis_type=eval([upper(analysis_type(1))     lower(analysis_type(2:end-8))     'SolutionEnum()']); end
if ischar(sub_analysis_type),sub_analysis_type=eval([upper(sub_analysis_type(1)) lower(sub_analysis_type(2:end-8)) 'AnalysisEnum()']); end

%check solution type is supported
if ~ismember(analysis_type,[DiagnosticSolutionEnum,PrognosticSolutionEnum,Prognostic2SolutionEnum,ThermalSolutionEnum,...
		SteadystateSolutionEnum,ParametersSolutionEnum,Transient2DSolutionEnum,Transient3DSolutionEnum...
		BalancedthicknessSolutionEnum,Balancedthickness2SolutionEnum,BalancedvelocitiesSolutionEnum,BedSlopeSolutionEnum,SurfaceSlopeSolutionEnum]),
	error(['process_solve_options error message: analysis_type ' EnumAsString(analysis_type) ' not supported yet!']);
end
if ~ismember(sub_analysis_type,[SteadyAnalysisEnum,NoneAnalysisEnum,HorizAnalysisEnum,GradientAnalysisEnum,InverseAnalysisEnum,VertAnalysisEnum]),
	error(['process_solve_options error message: sub_analysis_type ' sub_analysis_type ' not supported yet!']);
end
outoptions.analysis_type=analysis_type;
outoptions.sub_analysis_type=sub_analysis_type;

%  process qmu arguments
outoptions.qmudir=getfieldvalue(options,'qmudir','qmu');  % qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
outoptions.qmufile=getfieldvalue(options,'qmufile','qmu');% qmufile cannot be changed unless ????script.sh is also changed
outoptions.ivar=getfieldvalue(options,'ivar',1);
outoptions.iresp=getfieldvalue(options,'iresp',1);
outoptions.imethod=getfieldvalue(options,'imethod',1);
outoptions.iparams=getfieldvalue(options,'iparams',1);
outoptions.runmpi=getfieldvalue(options,'runmpi',false);
