/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{

	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	SubAnalysisTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticStokesAnalysisEnum,
	HorizAnalysisEnum,
	HutterAnalysisEnum,
	StokesAnalysisEnum,
	VertAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointStokesAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//transient
	Transient2DSolutionEnum,
	Transient2DAnalysisEnum,
	Transient3DSolutionEnum,
	Transient3DAnalysisEnum,
	SteadyAnalysisEnum,
	TransientAnalysisEnum, // needed by nighly run (to be removed at some point?)
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	Balancedthickness2SolutionEnum,
	Balancedthickness2AnalysisEnum,
	BalancedthicknessSolutionEnum,
	BalancedthicknessAnalysisEnum,
	BalancedvelocitiesSolutionEnum,
	BalancedvelocitiesAnalysisEnum,
	Prognostic2SolutionEnum,
	Prognostic2AnalysisEnum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//mesh2grid
	Mesh2gridAnalysisEnum,
	//parameters
	ParametersSolutionEnum,
	ParametersAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	SteadystateAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Formulations {{{1*/
	FormulationEnum,
	HutterFormulationEnum,
	MacAyealFormulationEnum,
	NoneFormulationEnum,
	PattynFormulationEnum,
	StokesFormulationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	/*Elements: */
	ElementEnum,
	BeamEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	SingEnum,
	TriaEnum,
	/*Grids: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadIceFrontEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentIcefrontEnum,
	SegmentRiftfrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BeamVertexInputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	SingVertexInputEnum,
	TriaVertexInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Rgb: */
	RgbEnum,
	/*Spc: */
	SpcEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AccumulationRateEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	ArtDiffEnum,
	BedEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmMaxDmpSlopeEnum,
	CmMaxDmpValueEnum,
	CmMinDmpSlopeEnum,
	CmMinDmpValueEnum,
	CmNoiseDmpEnum,
	CollapseEnum,
	ConstantEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DhDtEnum,
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	DtEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	EpsVelEnum,
	FillEnum,
	FitEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GeothermalFluxEnum,
	InternalEnum,
	KflagEnum,
	MaxPenetrationEnum,
	MeanVelEnum,
	MeltingOffsetEnum,
	MeltingRateEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	PressureOldEnum,
	QmuPressureEnum,
	PressureStokesEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	StabilizeConstraintsEnum,
	StokesReconditioningEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	TemperatureAverageEnum,
	ThicknessEnum,
	TypeEnum,
	VelEnum,
	VelObsEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxOldEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyOldEnum,
	QmuVyEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzOldEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	SingVertexElementResultEnum,
	BeamVertexElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	ResidualEnum,
	AbsoluteEnum,
	/*}}}*/
	/*Parameters{{{1*/
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	AdjointEnum,
	GradientEnum,
	OldGradientEnum,
	ConnectivityEnum,
	ControlParameterEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	ExtrudeParamEnum,
	HeatCapacityEnum,
	IsHutterEnum,
	IsMacAyealPattynEnum,
	IsStokesEnum,
	LatentHeatEnum,
	LowmemEnum,
	MaxIterEnum,
	MaxNonlinearIterationsEnum,
	MeltingPointEnum,
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NStepsEnum,
	NdtEnum,
	NumOutputEnum,
	NumRiftsEnum,
	NumberOfDofsPerNodeEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	OptScalEnum,
	OutputFileNameEnum,
	ParameterOutputEnum,
	PenaltyMeltingEnum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxNumSegmentsEnum,
	QmuMassFluxSegmentsEnum,
	QmuNPartEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	ResponseDescriptorsEnum,
	SolverStringEnum,
	SparsityEnum,
	TolXEnum,
	VariableDescriptorsEnum,
	VerboseEnum,
	WaitOnLockEnum,
	YtsEnum
	/*}}}*/
};

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);
char* EnumAsString(int enum_type);
int StringAsEnum(char* string);

#endif
