function femmodel=thermal_core_step(femmodel,step,time)
%THERMAL_CORE_STEP - core of the thermal solution for one step 
%
%   Usage:
%      femmodel=thermal_core_step(femmodel,step,time)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;

	displaystring(verbose,'\n%s',['computing temperature...']);
	femmodel=SetCurrentConfiguration(femmodel,ThermalAnalysisEnum);
	femmodel=solver_thermal_nonlinear(femmodel);

	displaystring(verbose,'\n%s',['compute melting...']);
	femmodel=SetCurrentConfiguration(femmodel,MeltingAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
end %end function
