/*!\file:  PenaltyConstraintsLocal.h
 * \brief local header files
 */ 

#ifndef _PENALTYCONSTRAINTSLOCAL_H
#define _PENALTYCONSTRAINTSLOCAL_H

#include "../../Container/Container.h"
#include "../../objects/objects.h"

/*melting: */
void  MeltingConstraints(Loads* loads, int* pconverged, int* pnum_unstable_constraints,int analysis_type);
int   MeltingIsPresent(Loads* loads,int analysis_type);

/*rifts: */
int   RiftConstraints(int* pconverged, int* pnum_unstable_constraints,Loads* loads,int min_mechanical_constraints,int analysis_type);
int   RiftIsPresent(Loads* loads,int analysis_type);
int   IsPreStable(Loads* loads);
int   SetPreStable(Loads* loads);
int   PreConstrain(int* pnum_unstable_constraints,Loads* loads);
int   Constrain(int* pnum_unstable_constraints,Loads* loads);
void  FreezeConstraints(Loads* loads);
int   MaxPenetrationInInputs(Loads* loads);
int   PotentialUnstableConstraints(Loads* loads);
int   IsMaterialStable(Loads* loads);
int   IsFrozen(Loads* loads);

#endif  /* _PENALTYCONSTRAINTSX_H */

