/*!\file:  MeltingIsPresent.cpp
 * \brief
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./PenaltyConstraintsLocal.h"

int MeltingIsPresent(Loads* loads,int analysis_type){

	int i;
	int found=0;
	int mpi_found=0;

	for(i=0;i<loads->Size();i++){
		Object* object=(Object*)loads->GetObjectByOffset(i);
		Load* load=(Load*)object;
		if(load->InAnalysis(analysis_type)){
			if (object->Enum()==PengridEnum){
				found=1;
				break;
			}
		}
	}
	
	#ifdef _PARALLEL_
	MPI_Reduce (&found,&mpi_found,1,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&mpi_found,1,MPI_INT,0,MPI_COMM_WORLD);                
	found=mpi_found;
	#endif

	return found;
}
