/*\file Reducevectorgtos.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtos.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec yg=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtosUsage);

	/*Input datasets: */
	FetchData(&yg,YG);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce vector: */
	Reducevectorgtosx(&ys,yg,nodesets);

	/*write output datasets: */
	WriteData(YS,ys);

	/*Free ressources: */
	delete nodesets;
	VecFree(&yg);
	VecFree(&ys);

	/*end module: */
	MODULEEND();
}

void ReducevectorgtosUsage(void)
{
	_printf_("\n");
	_printf_("   usage: ys = %s(yg,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
