/*\file Reducevectorgtof.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec ug=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Vec uf=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtofUsage);

	/*Input datasets: */
	FetchData(&ug,UG);
	FetchNodeSets(&nodesets,NODESETS);

	/*!Reduce vector: */
	Reducevectorgtofx(&uf,ug,nodesets);

	/*write output datasets: */
	WriteData(UF,uf);

	/*Free ressources: */
	delete nodesets;
	VecFree(&ug);
	VecFree(&uf);

	/*end module: */
	MODULEEND();
}

void ReducevectorgtofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: uf = %s(ug,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
