/*\file NormalizeConstraints.c
 *\brief: normalize constraints matrix for rigid body modes
 */

#include "./NormalizeConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Mat       Rmg=NULL;
	NodeSets* nodesets=NULL;

	/* output datasets: */
	Mat Gmn=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NormalizeConstraintsUsage);

	/*Input datasets: */
	FetchNodeSets(&nodesets,NODESETS);
	FetchData(&Rmg,RMG);

	/*!Generate internal degree of freedom numbers: */
	NormalizeConstraintsx(&Gmn, Rmg,nodesets);

	/*write output datasets: */
	WriteData(GMN,Gmn);

	/*Free ressources: */
	delete nodesets;
	MatFree(&Rmg);
	MatFree(&Gmn);

	/*end module: */
	MODULEEND();
}

void NormalizeConstraintsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Gmn] = %s(Rmg,nodesets);\n",__FUNCT__);
	_printf_("\n");
}
