/*\file MpcNodes.c
 *\brief:  handle rigid body modes.
 */

#include "./MpcNodes.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Constraints* constraints=NULL;
	int      analysis_type;

	/* output datasets: */
	Mat         Rmg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MpcNodesUsage);

	/*Input datasets: */
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&constraints,CONSTRAINTS);
	FetchData(&analysis_type,ANALYSISTYPE);

	/*!Generate internal degree of freedom numbers: */
	MpcNodesx( &Rmg, nodes,constraints,analysis_type); 
	
	/*write output datasets: */
	WriteData(RMG,Rmg);
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete constraints;
	MatFree(&Rmg);

	/*end module: */
	MODULEEND();
}

void MpcNodesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: m.Rmg=%s(m.nodes,m.constraints);\n",__FUNCT__);
	_printf_("\n");
}
