/*\file InputUpdateFromVector.c
*\brief: update elements properties using an input  vector
*/

#include "./InputUpdateFromVector.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	double*  vector=NULL;
	int      dummy;
	int      NameEnum;
	int      TypeEnum;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromVectorUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	FetchData(&vector,&dummy,VECTOR);
	FetchData(&NameEnum,NAME);
	FetchData(&TypeEnum,TYPE);

	/*Check that type is one of Constant, Vertex or Element: */
	if ((TypeEnum!=ConstantEnum) && (TypeEnum!=VertexEnum) && (TypeEnum!=ElementEnum)){
		ISSMERROR("%s%s%s\n","Type of input can only be a constant, a vertex or an element vector.  Right now, you input a ",EnumAsString(TypeEnum)," type data for input update");
	}

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromVectorx(elements,nodes,vertices,loads, materials,parameters,vector,NameEnum,TypeEnum);

	/*write output datasets: */
	WriteData(ELEMENTS,elements);
	WriteData(NODES,nodes);
	WriteData(VERTICES,vertices);
	WriteData(LOADS,loads);
	WriteData(MATERIALS,materials);
	WriteParams(PARAMETERS,parameters);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&vector);

	/*end module: */
	MODULEEND();
}

void InputUpdateFromVectorUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters,vector,name_enum,type_enum);\n",__FUNCT__);
	_printf_("\n");
}
