/*\file InputUpdateFromSolution.c
*\brief: update elements properties using a solution vector
*/

#include "./InputUpdateFromSolution.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	Vec      solution=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromSolutionUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	FetchData(&solution,SOLUTION);

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromSolutionx(elements,nodes,vertices,loads, materials,parameters,solution);

	/*write output datasets: */
	WriteData(ELEMENTS,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&solution);

	/*end module: */
	MODULEEND();
}

void InputUpdateFromSolutionUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements,nodes,vertices,loads,materials,parameters,solution);\n",__FUNCT__);
	_printf_("\n");
}
