/*\file InputScale.c
 *\brief: duplicate input
 */

#include "./InputScale.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      enum_type;
	double   scale_factor;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputScaleUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	FetchData(&enum_type,ENUMTYPE);
	FetchData(&scale_factor,SCALEFACTOR);

	/*!Call core code: */
	InputScalex( elements, nodes, vertices, loads, materials,parameters,enum_type, scale_factor);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputScaleUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, enum_type,scale_factor);\n",__FUNCT__);
	_printf_("\n");
}
