/*\file FieldDepthAverage.c
 *\brief: average field throfieldh thickness
 */

#include "./FieldDepthAverage.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	Vec      field=NULL;
	char*    fieldname=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&FieldDepthAverageUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&field,FIELD);
	FetchData(&fieldname,FIELDNAME);

	/*!Call core code: */
	FieldDepthAveragex(field,elements,nodes,vertices,loads,materials,parameters,fieldname);

	/*write output : */
	WriteData(FIELDOUT,field);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	VecFree(&field);
	xfree((void**)&fieldname);
	
	/*end module: */
	MODULEEND();

}

void FieldDepthAverageUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [field] = %s(elements, nodes, vertices, loads, materials, parameters,field,fieldname);\n",__FUNCT__);
	_printf_("\n");
}
