/*\file InputUpdateFromDakota.c
*\brief: update inputs using dakota input variables
*/

#include "./InputUpdateFromDakota.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements*   elements=NULL;
	Nodes*      nodes=NULL;
	Vertices*   vertices=NULL;
	Loads*      loads=NULL;
	Materials*  materials=NULL;
	Parameters* parameters=NULL;
	double*     responses=NULL;
	char**      responses_descriptors=NULL;
	char*       string=NULL;
	int         numresponses;
	mxArray*    pfield=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromDakotaUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	
	/*dakota input: */
	numresponses=mxGetM(RESPONSESDESCRIPTORS);
	responses_descriptors=(char**)xmalloc(numresponses*sizeof(char*));
	for(i=0;i<numresponses;i++){
		pfield=mxGetCell(RESPONSESDESCRIPTORS,i);
		stringlength = (mxGetM(pfield) * mxGetN(pfield) * sizeof(mxChar)) + 1 ;
		mxGetString(pfield,string,stringlength);
		
		responses_descriptors[i]=string;
	}

	/*Allocate responses: */
	responses=(double*)xmalloc(numresponses*sizeof(double));
	
	/*!Generate internal degree of freedom numbers: */
	DakotaResponsesx(responses,elements,nodes, vertices,loads,materials, parameters,responses_descriptors,numresponses);

	/*write output datasets: */
	WriteData(RESPONSES,responses,numresponses);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	xfree((void**)&responses);
	for(i=0;i<numresponses;i++){
		char* string=responses_descriptors[i]; xfree((void**)&string);
	}
	xfree((void**)&responses_descriptors);

	/*end module: */
	MODULEEND();
}

void InputUpdateFromDakotaUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements loads] = %s(elements,nodes,vertices,loads,materials,parameters,variables,variables_descriptors);\n",__FUNCT__);
	_printf_("\n");
}
