/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../objects/objects.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type){
	
	int verbose=0;
	Vec ug=NULL;
	int analysis_counter;
			
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	if(verbose)_printf_("%s\n"," updating boundary conditions...");
			
	/*set current analysis: */
	femmodel->SetCurrentConfiguration(analysis_type);

	GetSolutionFromInputsx( &ug, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,  femmodel->parameters);

	/*For this analysis_type, free existing boundary condition vectors: */
	analysis_counter=femmodel->analysis_counter;

	//global dof set
	VecFree(&femmodel->m_yg[analysis_counter]); 
	//in the s-set
	VecFree(&femmodel->m_ys[analysis_counter]);

	//Now, duplicate ug (the solution vector) into the boundary conditions vector on the g-set
	VecDuplicatePatch(&femmodel->m_yg[analysis_counter],ug);
	
	//Reduce from g to s set
	Reducevectorgtosx(&femmodel->m_ys[analysis_counter],femmodel->m_yg[analysis_counter],femmodel->m_nodesets[analysis_counter]);

	/*Free ressources:*/
	VecFree(&ug);

}
