/*
 * UpdateElementsThermal:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsThermal(Elements* elements, IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
	IoModelFetchData(&iomodel->drag_p,NULL,NULL,iomodel_handle,"drag_p");
	IoModelFetchData(&iomodel->drag_q,NULL,NULL,iomodel_handle,"drag_q");
	IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
	IoModelFetchData(&iomodel->pressure,NULL,NULL,iomodel_handle,"pressure");
	IoModelFetchData(&iomodel->temperature,NULL,NULL,iomodel_handle,"temperature");
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	cleanup_and_return:

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->drag_p);
	xfree((void**)&iomodel->drag_q);
	xfree((void**)&iomodel->elementoniceshelf);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->pressure);
	xfree((void**)&iomodel->temperature);
	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
}
