function md=process_qmu_response_data(md)
%PROCESS_QMU_RESPONSE_DATA - process any data necessary for the solutions to process the data. 
%
% Usage: md=process_qmu_response_data(md)
%
% See also PREQMU, PRESOLVE



for i=1:numel(md.responsedescriptors),
	if strncmpi(md.responsedescriptors{i},'mass_flux',9),
		indx=str2int(md.responsedescriptors{i}(10:end));
		if isempty(indx) || ~indx
			indx=1;
		end

		%we need a profile of points on which to compute the mass_flux, is it here? 
		if isnans(md.qmu_mass_flux_profile),
			error('process_qmu_response_data error message: could not find a mass_flux exp profile!');
		end
		if ~(ischar(md.qmu_mass_flux_profile) && (indx == 1)) && ...
		   ~(iscell(md.qmu_mass_flux_profile) && length(md.qmu_mass_flux_profile) >= indx && ischar(md.qmu_mass_flux_profile{indx})),
			error('process_qmu_response_data error message: mass_flux exp profile should be a domain outline name');
		end

		%ok, process the qmu_mass_flux_profile to build a list of segments: 
		if ischar(md.qmu_mass_flux_profile),
			md.qmu_mass_flux_segments=MassFluxProcessProfile(md);
			md.qmu_mass_flux_num_segments=size(md.qmu_mass_flux_segments,1);
		else
			if isempty(md.qmu_mass_flux_segments) || ~iscell(md.qmu_mass_flux_segments)
				md.qmu_mass_flux_segments=cell(numel(md.qmu_mass_flux_profile),1);
			end
			if isempty(md.qmu_mass_flux_num_segments) || ...
			   (numel(md.qmu_mass_flux_num_segments) == 1 && isnan(md.qmu_mass_flux_num_segments))
				md.qmu_mass_flux_num_segments=zeros(numel(md.qmu_mass_flux_profile),1);
			end
			save=md.qmu_mass_flux_profile;
			md.qmu_mass_flux_profile=md.qmu_mass_flux_profile{indx};
			md.qmu_mass_flux_segments{indx,1}=MassFluxProcessProfile(md);
			md.qmu_mass_flux_num_segments(indx,1)=size(md.qmu_mass_flux_segments{indx},1);
			md.qmu_mass_flux_profile=save;
			clear save
		end
	end
end

% for now, concatenate all segments from cells to make a double array for parallel
if iscell(md.qmu_mass_flux_segments)
	segments=zeros(0,5);
	for i=1:length(md.qmu_mass_flux_num_segments)
		if md.qmu_mass_flux_num_segments(i)
			segments=[segments; md.qmu_mass_flux_segments{i}];
		end
	end
	md.qmu_mass_flux_segments=segments;
	clear segments
end

