function femmodel=surfaceslope_core(femmodel)
%SURFACESLOPE_CORE - core of the surface slope computation solution
%
%   Usage:
%      femmodel=surfaceslope_core(femmodel)
%

	%Recover some parameters:
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;
	solution_type=femmodel.parameters.SolutionType;

	displaystring(verbose,'\n%s',['computing surface slope...']);

	%Call on core computations: 
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	%extrude inputs if we are in 3D: */
	if dim==3,
		displaystring(verbose,'\n%s',['extruding surface slope in 3d...']);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	end
	
	if solution_type==SurfaceSlopeSolutionEnum,
		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	end

end %end function
