/*!\file: prognostic2_core.cpp
 * \brief: core of the prognostic2 solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic2_core(FemModel* femmodel){

	/*flags: */
	int verbose=0;
	int solution_type;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(Prognostic2AnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_("depth averaging velocity...\n");
	InputDepthAveragex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VxEnum,VxAverageEnum);
	InputDepthAveragex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VyEnum,VyAverageEnum);

	_printf_("call computational core:\n");
	solver_linear(NULL,femmodel);
	
	_printf_("Averaging over vertices:\n");
	//FieldAverageOntoVerticesx(&h_g,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	//_printf_("extrude computed thickness on all layers:\n");
	//FieldExtrudex(h_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	if(verbose)_printf_("saving results:\n");
	if(solution_type==Prognostic2SolutionEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}

}
