function md=issm(md);
%ISSM - ISSM main parallel program
%
%   Usage:
%      md=issm(md)
%
	%timing
	t1=clock;

	solution_type=md.analysis_type;

	%out of solution_type, figure out solution core function pointer, and types of analyses needed:
	[analyses,numanalyses,solutioncore]=SolutionConfiguration(solution_type);

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;
	control_analysis=femmodel.parameters.ControlAnalysis;

	%compute solution
	if ~qmu_analysis,
		if ~control_analysis,
			
			displaystring(verbose,'%s',['call computational core']);
			eval(['femmodel=' solutioncore '(femmodel);']);

		else,
			
			displaystring(verbose,'%s',['call computational core']);
			femmodel=control_core(femmodel);

		end
		
		displaystring(verbose,'%s',['write results'])
		results=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
		md.results.(EnumAsString(solution_type))=ProcessPatch(results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel,femmodel.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
