/*!\file Icefront.h
 * \brief: header file for icefront object
 */

#ifndef _ICEFRONT_H_
#define _ICEFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class IoModel;

#define MAX_ICEFRONT_GRIDS 4 //max number of grids for a certain load
#define ICEFRONTSTRING 20 //max string length
/*}}}*/

class Icefront: public Load {

	public:
		int id;
		int analysis_type;

		/*hooks: */
		Hook* hnodes;
		Hook* helement;
		Hook* hmatpar;

		/*inputs and parameters: */
		Inputs* inputs;
		Parameters* parameters;

		/*Icefront constructors, destructors: {{{1*/
		Icefront();
		Icefront(int icefront_id,int i, IoModel* iomodel,int analysis_type);
		~Icefront();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Load management: {{{1*/
		void  CreatePVectorDiagnosticHoriz( Vec pg);
		void  CreatePVectorDiagnosticHorizSegment( Vec pg);
		void  CreatePVectorDiagnosticHorizQuad( Vec pg);
		void  CreatePVectorDiagnosticStokes( Vec pg);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  SegmentPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, double* normal,double length);
		void  QuadPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  QuadPressureLoadStokes(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		/*}}}*/
};

#endif  /* _ICEFRONT_H_ */
