function bg = bamggeom(varargin)
%BAMGGEOM - constructor for bamggeom object
%
%   Usage:
%      bamggeom = bamggeom(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	bg.Vertices=[];
	bg.Edges=[];
	bg.TangentAtEdges=[];
	bg.Corners=[];
	bg.RequiredVertices=[];
	bg.RequiredEdges=[];
	bg.CrackedEdges=[];
	bg.hVertices=[];
	bg.MetricVertices=[];
	bg.h1h2VpVertices=[];
	bg.SubDomains=[];

	bg=class(bg,'bamggeom');

case 1

	bg=bamggeom;
	object=varargin{1};
	fields=fieldnames(object);
	for i=1:length(fields)
		field=fields{i};
		if isfield(struct(bg),field),
			bg.(field)=object.(field);
		end
	end

otherwise
	error('bamggeom constructor error message: unknown type of constructor call');
end
