/*!\file: UpdateCounter.cpp
 * \brief update counters after adding objects to a dataset.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"

void    UpdateCounters(IoModel* iomodel,Nodes** pnodes,Loads** ploads, Constraints** pconstraints){

	Nodes* nodes=NULL;
	Loads* loads=NULL;
	Constraints* constraints=NULL;

	/*recover pointers: */
	nodes=*pnodes;
	loads=*ploads;
	constraints=*pconstraints;


	if(nodes) iomodel->nodecounter=nodes->NumberOfNodes();
	else iomodel->nodecounter=0;

	if(loads)iomodel->loadcounter=loads->NumberOfLoads();
	else iomodel->loadcounter=0;
	
	if(constraints)iomodel->constraintcounter=constraints->NumberOfConstraints();
	else iomodel->constraintcounter=0;

}
