/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define  _SHARED_ELEMENTS_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"

void ResolvePointers(Object** objects,int* object_ids,int* object_offsets,int num_objects,DataSet* dataset);
double Paterson(double temperature);
int GetVerticesCoordinates(double* xyz,  Node** nodes, int numgrids);
inline void printarray(double* array,int lines,int cols=1){
	int i,j;
	printf("\n");
	for (i=0;i<lines;i++){  
		printf("   [ ");
		for (j=0;j<cols;j++){
			printf(" %12.6g ",array[i*cols+j]);
		}  
		printf(" ]\n");
	}  
	printf("\n");
}
inline void printarray(int* array,int lines,int cols=1){
	int i,j;
	printf("\n");
	for (i=0;i<lines;i++){  
		printf("   [ ");
		for (j=0;j<cols;j++){
			printf(" %6i",array[i*cols+j]);
		}  
		printf(" ]\n");
	}  
	printf("\n");
}

#endif //ifndef _SHARED_ELEMENTS_H_
