function femmodel=diagnostic_core(femmodel);
%DIAGNOSTIC_CORE - compute the core velocity field 
%
%   Usage:
%      results=diagnostic_core(model);
%

	%some parameters
	modify_loads=boolean(1);
	conserve_loads=boolean(1);

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;
	ishutter=femmodel.parameters.IsHutter;
	ismacayealpattyn=femmodel.parameters.IsMacAyealPattyn;
	isstokes=femmodel.parameters.IsStokes;
	if(isstokes) stokesreconditioning=femmodel.parameters.stokesreconditioning; end
	qmu_analysis=femmodel.parameters.QmuAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%for qmu analysis, be sure the velocity input we are starting from  is the one in the parameters: 
	if qmu_analysis,
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,QmuVxEnum,VxEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,QmuVyEnum,VyEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,QmuVzEnum,VzEnum);
		femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,QmuPressureEnum,PressureEnum);
	end

	%Compute slopes: 
	if(ishutter), femmodel=surfaceslope_core(femmodel); end
	if(isstokes), femmodel=bedslope_core(femmodel); end

	if ishutter,

		displaystring(verbose,'\n%s',['computing hutter velocities...']);
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticHutterAnalysisEnum);
		femmodel=solver_linear(femmodel);

		if(ismacayealpattyn)femmodel=ResetBoundaryConditions(femmodel,DiagnosticAnalysisEnum,HorizAnalysisEnum); end

	end
			
	if ismacayealpattyn,

		displaystring(verbose,'\n%s',['computing horizontal velocities...']);
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
		femmodel=solver_diagnostic_nonlinear(femmodel,modify_loads); 
	end
	

	if dim==3,
	
		displaystring(verbose,'\n%s',['computing vertical velocities...']);
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticVertAnalysisEnum);
		femmodel=solver_linear(femmodel);

		if isstokes,

			%"recondition" pressure computed previously:
			femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,PressureStokesEnum);
			femmodel.elements=InputScale(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureStokesEnum,1.0/stokesreconditioning);

			displaystring(verbose,'\n%s',['update boundary conditions for stokes using velocities previously computed...']);
			femmodel=ResetBoundaryConditions(femmodel,DiagnosticAnalysisEnum,StokesAnalysisEnum);

			displaystring(verbose,'\n%s',['computing stokes velocities and pressure...']);
			femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum);
			femmodel=solver_diagnostic_nonlinear(femmodel,conserve_loads); 
		end
	end

	if solution_type==DiagnosticSolutionEnum,
		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum);
		if(dim==3) femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum); end
	end
