/*
 * UpdateElementsControl:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsControl(Elements* elements, IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;
	double*  control_parameter=NULL;

	/*Get out if no Control Requested*/
	if(!iomodel->control_analysis) return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->vx_obs,NULL,NULL,iomodel_handle,"vx_obs");
	IoModelFetchData(&iomodel->vy_obs,NULL,NULL,iomodel_handle,"vy_obs");
	IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,"weights");
	IoModelFetchData(&control_parameter,NULL,NULL,iomodel_handle,iomodel->control_type);

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}
	cleanup_and_return:

	/*Free data: */
	xfree((void**)&iomodel->vx_obs);
	xfree((void**)&iomodel->vy_obs);
	xfree((void**)&iomodel->weights);
	xfree((void**)&control_parameter);
}
