/*!\file: balancedvelocities_core.cpp
 * \brief: core of the balancedvelocities solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancedvelocities_core(FemModel* femmodel){

	/*flags: */
	int verbose=0;
	int dim;
	int solution_type;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(BalancedvelocitiesAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_("depth averaging velocity...\n");
	InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VxEnum,VxAverageEnum);
	InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VyEnum,VyAverageEnum);
	if(dim==3) InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VzEnum,VzAverageEnum);

	_printf_("call computational core:\n");
	solver_linear(NULL,femmodel);

	_printf_("extrude computed velocity on all layers:\n");
	InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VxEnum);
	InputExtrudex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VyEnum);

	if(verbose)_printf_("saving results:\n");
	if(solution_type==BalancedvelocitiesSolutionEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,VyEnum);
	}

}
