/*!\file:  diagnostic.cpp
 * \brief: diagnostic solution
 */ 

#include "../issm.h"
#include "./parallel.h"

#undef __FUNCT__ 
#define __FUNCT__ "diagnostic"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


int main(int argc,char* *argv){
	
	/*I/O: */
	FILE* fid=NULL;
	char* inputfilename=NULL;
	char* outputfilename=NULL;
	char* lockname=NULL;
	int   numberofnodes;

	/*Fem models : */
	FemModel femmodels[5];
	
	Vec u_g=NULL;
	Vec p_g=NULL;
	ParameterInputs* inputs=NULL;
	int waitonlock=0;
	
	double* u_g_initial=NULL;
	Param*  param=NULL;

	MODULEBOOT();

	#if !defined(_PARALLEL_) || (defined(_PARALLEL_) && !defined(_HAVE_PETSC_))
	throw ErrorException(__FUNCT__," parallel executable was compiled without support of parallel libraries!");
	#endif

	PetscInitialize(&argc,&argv,(char *)0,"");  

	/*Size and rank: */
	MPI_Comm_rank(MPI_COMM_WORLD,&my_rank);  
	MPI_Comm_size(MPI_COMM_WORLD,&num_procs); 

	_printf_("recover , input file name and output file name:\n");
	inputfilename=argv[2];
	outputfilename=argv[3];
	lockname=argv[4];

	/*Open handle to data on disk: */
	fid=fopen(inputfilename,"rb");
	if(fid==NULL) throw ErrorException(__FUNCT__,exprintf("%s%s%s","could not open file ",inputfilename," for binary reading")); 

	_printf_("read and create finite element model:\n");
	CreateFemModel(&femmodels[0],fid,"diagnostic_horiz");
	CreateFemModel(&femmodels[1],fid,"diagnostic_vert");
	CreateFemModel(&femmodels[2],fid,"diagnostic_stokes");
	CreateFemModel(&femmodels[3],fid,"diagnostic_hutter");
	CreateFemModel(&femmodels[4],fid,"slope_compute");

	_printf_("initialize inputs:\n");
	femmodels[0].parameters->FindParam((void*)&u_g_initial,"u_g");
	femmodels[0].parameters->FindParam((void*)&numberofnodes,"numberofnodes");

	inputs=new ParameterInputs;
	inputs->Add("velocity",u_g_initial,3,numberofnodes);

	/*erase velocities: */
	param=(Param*)femmodels[0].parameters->FindParamObject("u_g");
	femmodels[0].parameters->DeleteObject((Object*)param);

	_printf_("call computational core:\n");
	diagnostic_core(&u_g,&p_g,femmodels,inputs);

	_printf_("write results to disk:\n");
	OutputDiagnostic(u_g,p_g,&femmodels[0],outputfilename);

	_printf_("write lock file:\n");
	femmodels[0].parameters->FindParam((void*)&waitonlock,"waitonlock");
	if (waitonlock){
		WriteLockFile(lockname);
	}
		
	_printf_("closing MPI and Petsc\n");
	MPI_Barrier(MPI_COMM_WORLD);

	/*Close MPI libraries: */
	PetscFinalize(); 


	/*end module: */
	MODULEEND();
	
	return 0; //unix success return;
}
