#!/bin/bash

#Get number of cpus
NUMCPUS=$1;

#version of mpich2
version=1.0.2p1

#Some cleanup
rm -rf src install mpich2-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  mpich2-$version.tar.gz

#Move mpich2 into src directory
mv mpich2-$version/* src
rm -rf mpich2-$version

#Configure mpich2
cd src
make distclean
source ../configure.sh

#Apply Patch to examples
patch ./examples/Makefile ../Examples.Makefile.patch
patch -R ./src/binding/cxx/mpicxx.h ../mpicxx.h.patch
patch -R ./src/include/mpicxx.h ../mpicxx.h.patch

#Compile mpich2
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
make install 

cd ../install/lib
rm -rf *.so
