function femmodel=bedslope_core(femmodel)
%BEDSLOPE_CORE - core of the bed slope computation solution
%
%   Usage:
%      femmodel=bedslope_core(femmodel)
%

	%Recover some parameters:
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;
	solution_type=femmodel.parameters.SolutionType;

	displaystring(verbose,'\n%s',['computing bed slope...']);

	%Call on core computations: 
	femmodel=SetCurrentAnalysisAlias(femmodel,BedSlopeAnalysisEnum,BedSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentAnalysisAlias(femmodel,BedSlopeAnalysisEnum,BedSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	%extrude inputs if we are in 3D: */
	if dim==3,
		displaystring(verbose,'\n%s',['extruding bed slope in 3d...']);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,BedSlopeXEnum);
		femmodel.elements=InputExtrude(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,BedSlopeYEnum);
	}
	
	if solution_type==BesSlopeSolutionEnum,
		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedSlopeYEnum);
	end
