function plot_manager(md,options,subplotwidth,nlines,ncols,i);
%PLOT__MANAGER - distribute the plots, called by plotmodel
%
%   Usage:
%      plot_manager(md,options,subplotwidth,i);
%
%   See also: PLOTMODEL, PLOT_UNIT

%parse options and get a structure of options. 
options=checkplotoptions(md,options);

%get data to be displayed
data=getfieldvalue(options,'data');

%figure out if this is a special plot
if ischar(data),

	switch data,

		case 'boundaries',
			plot_boundaries(md,options,subplotwidth,i);
			return;
		case 'BC',
			plot_BC(md,options,subplotwidth,i,data);
			return;
		case 'elementnumbering',
			plot_elementnumbering(md,options,subplotwidth,i);
			return;
		case 'highlightelements',
			plot_highlightelements(md,options,subplotwidth,i);
			return;
		case 'segmentnumbering',
			plot_segmentnumbering(md,options,subplotwidth,i);
			return;
		case 'histnorm',
			plot_qmuhistnorm(md,options,subplotwidth,i);
			return;
		case 'elements_type',
			plot_elementstype(md,options,subplotwidth,i);
			return;
		case 'gridnumbering',
			plot_gridnumbering(md,options,subplotwidth,i);
			return;
		case 'highlightgrids',
			plot_highlightgrids(md,options,subplotwidth,i);
			return;
		case {'basal_drag','basal_dragx','basal_dragy'},
			plot_basaldrag(md,options,subplotwidth,i,data);
			return;
		case 'driving_stress',
			plot_drivingstress(md,options,subplotwidth,i);
			return;
		case 'mesh',
			plot_mesh(md,options,nlines,ncols,i);
			return;
		case 'none',
			plot_none(md,options,nlines,ncols,i);
			return;
		case 'penalties',
			plot_penalties(md,options,subplotwidth,i);
			return;
		case 'partition',
			plot_partition(md,options,nlines,ncols,i);
			return;
		case 'riftvel',
			plot_riftvel(md,options,nlines,ncols,i);
			return;
		case 'rifts',
			plot_rifts(md,options,nlines,ncols,i);
			return;
		case 'riftrelvel',
			plot_riftrelvel(md,options,nlines,ncols,i);
			return;
		case 'riftpenetration',
			plot_riftpenetration(md,options,nlines,ncols,i);
			return;
		case 'riftfraction',
			plot_riftfraction(md,options,nlines,ncols,i);
			return;
		case 'sarpwr',
			plot_sarpwr(md,options,subplotwidth,i)
			return
		case 'pressureload'
			plot_pressureload(md,options,subplotwidth,i,data)
			return
		case 'segments'
			plot_segments(md,options,subplotwidth,i,data)
			return
		case {'strainrate_tensor','strainrate','strainrate_principal','strainrate_principalaxis1','strainrate_principalaxis2','strainrate_principalaxis3',...
				'stress_tensor','stress','stress_principal','stress_principalaxis1','stress_principalaxis2','stress_principalaxis3',...
				'deviatoricstress_tensor','deviatoricstress','deviatoricstress_principal','deviatoricstress_principalaxis1','deviatoricstress_principalaxis2','deviatoricstress_principalaxis3'},
			plot_tensor(md,options,subplotwidth,i,data);
			return;
		case 'thermaltransient_results',
			plot_thermaltransient_results(md,options,subplotwidth,i);
			return;
		case 'transient_movie',
			plot_transient_movie(md,options,subplotwidth,i);
			return;
		case 'transient_results',
			plot_transient_results(md,options,subplotwidth,i);
		case {'transient_thickness','transient_bed','transient_surface','transient_temperature','transient_melting','transient_vel','transient_vx','transient_vy','transient_vz','transient_pressure'}
			plot_transient_field(md,options,subplotwidth,i,data);
			return;

	otherwise,

		if isfield(struct(md),data)
			data=eval(['md.' data ';']);
		else
			error('plot error message: data provided not supported yet. Type plotdoc for help');
		end
	end
end

%Figure out if this is a semi-transparent plot.
if exist(options,'overlay'),
	plot_overlay(md,data,options,nlines,ncols,i);
	return;
end

%Figure out if this is a Section plot
if exist(options,'sectionvalue')
	plot_section(md,data,options,subplotwidth,i);
	return;
end

%process data and model
[x y z elements is2d]=processmesh(md,data,options);
[data2 datatype]=processdata(md,data,options);

%standard plot:
subplot(nlines,ncols,i);

%apply position change: 
if exist(options,'position')
	set(gca,'Position',getfieldvalue(options,'position'));
end

%plot unit
plot_unit(x,y,z,elements,data2,is2d,datatype,options);

%apply all options
if datatype==3,
	options=changefieldvalue(options,'colorbar',2);
	if exist(options,'contourlevels'),
		data2=data;
	end
end

applyoptions(md,data2,options);

%plot inset if requested
if exist(options,'inset'),

	%get inset relative position (x,y,width,height)
	insetpos=getfieldvalue(options,'insetpos',[0.56 0.55 0.35 0.35]);
	%get current plos position
	cplotpos=get(gca,'pos');
	%compute inset position
	PosInset=[cplotpos(1)+insetpos(1)*cplotpos(3),cplotpos(2)+insetpos(2)*cplotpos(4), insetpos(3)*cplotpos(3), insetpos(4)*cplotpos(4)];
	%show pos
	if strcmpi(getfieldvalue(options,'showinset','off'),'on')
		X1=getfieldvalue(options,'insetx',[min(x) max(x)]);
		Y1=getfieldvalue(options,'insety',[min(y) max(y)]);
		line(X1([1 2 2 1 1]),Y1([1 1 2 2 1]),zeros(1,5),'Color','k','LineWidth',2);
	end

	%plot inset
	axes('pos',PosInset);
	box('on')
	plot_unit(x,y,z,elements,data2,is2d,datatype,options);

	%applay options
	options=changefieldvalue(options,'colorbar',0);
	options=changefieldvalue(options,'text',{});
	options=changefieldvalue(options,'latlon','off');
	options=changefieldvalue(options,'axis','equal off');
	options=changefieldvalue(options,'xlim',getfieldvalue(options,'insetx',[min(x) max(x)]));
	options=changefieldvalue(options,'ylim',getfieldvalue(options,'insety',[min(y) max(y)]));
	applyoptions(md,data2,options);
end
