function plot_elementnumbering(md,options,width,i);
%PLOT_ELEMENTNUMBERING - plot element numbering
%
%   Usage:
%      plot_elementnumbering(md,options,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_MANAGER

subplot(width,width,i); 

%process data and model
[x y z elements is2d]=processmesh(md,[],options);
[elementnumbers datatype]=processdata(md,[1:md.numberofelements]',options);

%plot
if is2d
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(elements,1),
		text(sum(x(elements(i,:)))/3,sum(y(elements(i,:)))/3,sum(z(elements(i,:)))/3,num2str(elementnumbers(i)));
		if ismember(elementnumbers(i),getfieldvalue(options,'highlight',[]))
			A=elements(i,1); B=elements(i,2);  C=elements(i,3);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
else
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(elements,1),
		text(sum(x(elements(i,:)))/6,sum(y(elements(i,:)))/6,sum(z(elements(i,:)))/6,num2str(elementnumbers(i)));
		if ismember(elementnumbers(i),getfieldvalue(options,'highlight',[]))
			A=elements(i,1); B=elements(i,2);  C=elements(i,3);  D=elements(i,4); E=elements(i,5);  F=elements(i,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
end

%apply options
options=addfielddefault(options,'title','Element numbering');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
