function md=prognostic(md)
%PROGNOSITC - prognostic solution sequence.
%
%   Usage:
%      md=prognostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	numanalyses=1;
	analyses=[PrognosticAnalysisEnum];
	solution_type=PrognosticSolutionEnum;
	
	displaystring(md.verbose,'%s',['reading prognostic model data']);
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);

	% figure out number of dof: just for information purposes.
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=prognostic_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		results=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
		md.results.(EnumAsString(solution_type))=ProcessPatch(results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel,femmodel.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
