function md = model(varargin)
%MODEL - constructor for a model
%
%   Usage:
%      md = model(varargin)

switch nargin

case 0
	% if no input arguments, create a default object

	%Model general information
	md.notes='';
	md.name='';
	md.counter=0; %1 mesh, 2 geography, 3 parameterize
	md.domainoutline=NaN;
	md.riftoutline=NaN;
	md.iceshelfoutline=NaN;
	md.icesheetoutline=NaN;
	md.wateroutline=NaN;
	md.parameterfile=NaN;
	
	%Mesh
	md.bamg=NaN;
	md.dim=0;
	md.numberofelements=0;
	md.numberofgrids=0;
	md.elements=NaN;
	md.elements_type=NaN;
	md.x=NaN;
	md.y=NaN;
	md.z=NaN;
	md.bed_slopex=NaN;
	md.bed_slopey=NaN;
	md.surface_slopex=NaN;
	md.surface_slopey=NaN;
	md.nodeconnectivity=NaN;
	md.elementconnectivity=NaN;
	md.edges=NaN;

	%Initial 2d mesh 
	md.numberofelements2d=0;
	md.numberofgrids2d=0;
	md.elements2d=NaN;
	md.elements_type2d=NaN;
	md.x2d=NaN;
	md.y2d=NaN;
	md.z2d=NaN;
		
	%latlon of the coorinates
	md.lat=NaN;
	md.long=NaN;
	md.hemisphere=NaN;

	%Elements type
	md.ishutter=0;
	md.ismacayealpattyn=0;
	md.isstokes=0;

	%Elements
	md.elementonhutter=NaN;
	md.elementonmacayeal=NaN;
	md.elementonpattyn=NaN;
	md.elementonstokes=NaN;

	%Nodes
	md.gridonhutter=NaN;
	md.gridonmacayeal=NaN;
	md.gridonpattyn=NaN;
	md.gridonstokes=NaN;
	md.borderstokes=NaN;

	%Stokes mesh
	md.stokesreconditioning=0;
	
	%Penalties
	md.penalties=NaN;
	md.penalty_offset=0;
	md.penalty_melting=0;
	md.penalty_lock=0;
	md.segments=NaN;
	md.segmentmarkers=NaN;
	md.rifts=NaN;
	md.riftinfo=NaN;
	md.riftproperties=NaN;
	md.numrifts=0;

	%Projections
	md.uppergrids=NaN;
	md.upperelements=NaN;
	md.lowerelements=NaN;
	md.lowergrids=NaN;
	md.deadgrids=NaN;
	
	%Extrusion
	md.numlayers=0;
	md.extrusionexponent=0;
	md.elementonbed=NaN;
	md.elementonsurface=NaN;
	md.gridonbed=NaN;
	md.gridonsurface=NaN;
	md.minh=0;
	md.firn_layer=NaN;

	%Extraction
	md.extractedgrids=NaN;
	md.extractedelements=NaN;
	
	%Materials parameters
	md.rho_ice=0;
	md.rho_water=0;
	md.rho_firn=0;
	md.heatcapacity=0;
	md.latentheat=0;
	md.thermalconductivity=0;
	md.meltingpoint=0;
	md.beta=0;
	md.mixed_layer_capacity=0;
	md.thermal_exchange_velocity=0;
	md.min_thermal_constraints=0;
	md.min_mechanical_constraints=0;
	md.stabilize_constraints=0;
	
	%Physical parameters
	md.g=0;
	md.yts=0;
	md.drag_type=0;
	md.drag_coefficient=NaN;
	md.drag_p=NaN;
	md.drag_q=NaN;
	md.rheology_B=NaN;
	md.rheology_n=NaN;

	%Geometrical parameters
	md.elementoniceshelf=NaN;
	md.elementonicesheet=NaN;
	md.elementonwater=NaN;
	md.gridoniceshelf=NaN;
	md.gridonicesheet=NaN;
	md.gridonwater=NaN;
	md.surface=NaN;
	md.thickness=NaN;
	md.bed=NaN;
	md.bathymetry=NaN;

	%Boundary conditions
	md.gridonboundary=NaN;
	md.pressureload=NaN;
	md.spcvelocity=NaN;
	md.spctemperature=NaN;
	md.spcthickness=NaN;

	%Observations
	md.vx_obs=NaN;
	md.vy_obs=NaN;
	md.vel_obs=NaN;
	md.vx_obs_raw=NaN;
	md.vy_obs_raw=NaN;
	md.vx_bal=NaN;
	md.vy_bal=NaN;
	md.vel_bal=NaN;
	md.vel_obs_raw=NaN;
	md.accumulation_rate=NaN;
	md.dhdt=NaN;
	md.geothermalflux=NaN;
	md.observed_temperature=NaN;

	%Statics parameters
	md.eps_res=0;
	md.eps_rel=0;
	md.eps_abs=0;
	md.max_nonlinear_iterations=0;
	md.sparsity=0;
	md.connectivity=0;
	md.lowmem=0;
	md.viscosity_overshoot=0;
	
	%Transient parameters
	md.dt=0;
	md.ndt=0;
	md.artificial_diffusivity=0;
	md.timestepping=0;
	md.deltaH=0;
	md.DeltaH=0;
	md.deltaT=0;
	md.DeltaT=0;
	md.timeacc=0;
	md.timedec=0;

	%Control
	md.control_analysis=0;
	md.control_type='';
	md.weights=[];
	md.nsteps=0;
	md.maxiter=[];
	md.fit=[];
	md.tolx=0;
	md.optscal=[];
	md.eps_cm=0;
	md.cm_noisedmp=0;
	md.cm_mindmp_value=0;
	md.cm_mindmp_slope=0;
	md.cm_maxdmp_value=0;
	md.cm_maxdmp_slope=0;
	md.cm_min=0;
	md.cm_max=0;
	md.cm_jump=[];
	md.cm_gradient=0;
	md.epsvel=0;
	md.meanvel=0;

	%Output parameters
	md.numoutput=0;
	md.parameteroutput={};
	md.viscousheating=NaN;
	md.pressure_elem=NaN;
	md.stress=NaN;
	md.stress_surface=NaN;
	md.stress_bed=NaN;
	md.deviatoricstress=NaN;
	md.strainrate=NaN;
	md.plot=0;

	%debugging
	md.verbose=0;
	md.element_debug=0;
	md.element_debugid=NaN;
	md.mem_debug=0;
	md.memoryleaks=NaN;

	%Results fields
	md.inputfilename='';
	md.outputfilename='';
	md.results=struct();
	md.vx=NaN;
	md.vy=NaN;
	md.vz=NaN;
	md.vel=NaN;
	md.temperature=NaN; %temperature solution vector
	md.melting_rate=NaN;
	md.pressure=NaN;

	%Parallelisation parameters
	md.cluster='';
	md.np=0;
	md.time=0;
	md.queue='';
	md.exclusive=0;
	md.scheduler_configuration='';
	md.outlog='';
	md.errlog='';
	md.alloc_cleanup=1;
	md.waitonlock=0;

	%mesh2grid
	md.mesh2grid_parameters={};
	md.mesh2grid_data=NaN;
	md.mesh2grid_xm=NaN;
	md.mesh2grid_ym=NaN;

	%dummy
	md.dummy=NaN;

	%mesh 
	md.mesh_domainoutline='';
	md.mesh_riftoutline='';
	md.mesh_resolution=NaN;

	%PETSc and MATLAB solver string
	md.solverstring='';
	md.solver_type='';

	%Analysis and sub_analysis
	md.analysis_type='';
	md.sub_analysis_type='';

	%management of large models
	md.repository='';

	%radar power images
	md.sarpwr=NaN;
	md.sarxm=NaN;
	md.sarym=NaN;

	%qmu
	md.variables=struct();
	md.responses=struct();
	md.qmu_method=struct();
	md.qmu_params=struct();
	md.dakotaresults=struct();
	md.dakotain='';
	md.dakotaout='';
	md.dakotadat='';
	md.qmu_analysis=0;
	md.part=[];
	md.npart=0;
	md.numberofvariables=0;
	md.numberofresponses=0;
	md.variabledescriptors=NaN;
	md.responsedescriptors=NaN;
	md.qmu_mass_flux_profile=NaN;
	md.num_qmu_mass_flux_segments=NaN;
	md.qmu_mass_flux_segments=NaN;

	%partitioner:
	md.adjacency=[];
	md.vwgt=[];


	%output
	md=class(md,'model');

	%set default parameters
	md=setdefaultparameters(md);

case 1
	%If single argument of class model, we have a copy constructor. 
	if (isa(varargin{1},'model'))
		md = varargin{1};
	elseif (isa(varargin{1},'char'))
		%user gave us the name of the repository, this model is going to be large! 
		md=model;
		md.repository=varargin{1};
		md=activaterepository(md);
	else
		error('model constructor error message: copy constructor called on a non ''model'' class object');
	end 
otherwise
	error('model constructor error message: 0 of 1 argument only in input.');
end
