/*!\file: Patch.h
 * \brief prototypes for Patch.h
 */ 

/*A Patch object is used to store all results held in elements, in a serial way, and to dump them to disk. 
	
	Each row of the Patch object is made of the following information: 
	- the result enum_type, 
	- the step and time, 
	- the id of the element, 
	- the interpolation type, 
	- the vertices ids, 
	- and the values at the nodes (could be different from the vertices).
	
	For ex: 
	1. on a Beam element, Vx, at step 1, time .5, element id 1, interpolation type P0 (constant), vertices ids 1 and 2, one constant value 4.5
	   VxEnum 1  .5  1 P0  1 2       4.5 NaN  NaN
	2. on a Tria element, Vz, at step 2, time .8, element id 2, interpolation type P1 (linear), vertices ids 1 3 and 4, with values at 3 nodes 4.5, 3.2, 2.5
	   VzEnum 2  .8  2 P1  1 3 4     4.5 3.2  2.5
*/


#ifndef _PATCH_H_
#define  _PATCH_H_

/*Headers:*/
/*{{{1*/
/*}}}*/

class Patch{

	public:

		int     numrows; //number of results held in Patch object
		int     numcols; //number of columns
		int     maxvertices; //maxvertices corresponds to largest amount of vertices on a given element, determined by the geometry.
		int     maxnodes;    // maxnodes corresponds to the largest amout of nodes on a given element, determined by the interpolation type.
		
		double* values;  //result values

		Patch();
		Patch(int numrows, int maxvertices, int maxnodes);
		~Patch();
		void fillelementinfo(int row, int element_id, int* vertices_ids, int num_vertices);
		void fillresultinfo(int row,int enum_type,int step, double time, int interpolation, double* nodal_values, int num_nodes);
		void MPI_Gather(void);

};

#endif //ifndef _PATCH_H_
