/*!\file: MatlabWriteResults.cpp
 * \brief: write results into a matlab array
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_

#include <mex.h>
#include "../../io/io.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

void  MatlabWriteResults(mxArray** pdataref, Parameters* parameters, DataSet* results){

	int i,j;
	int count;

	/*output: */
	mxArray* dataref=NULL;
	mwSize nfields;
	mwSize maxfields;
	mwSize nsteps;
	mwSize step;
	const	char**	fnames=NULL;
	int*    enums=NULL;
	int     baseenum;
	mwSize		onebyone[2] = {1,1};
	mwSize		ndim=2;

	/*How many time steps do we have? : */
	nsteps=0;
	for(i=0;i<results->Size();i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);
		step=result->GetStep();
		if(step>nsteps)nsteps=step;
	}
	onebyone[0]=nsteps;

	/*How many field names do we have. First, figure out how many result types we have: */
	maxfields=(mwSize)results->Size();
	enums=(int*)xmalloc(maxfields*sizeof(int));
	for(i=0;i<maxfields;i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);
		enums[i]=result->EnumType();
	}
	/*Now, make result types unique: */
	for(i=0;i<maxfields;i++){
		if(enums[i]>=0){//if <0, it means this enum was found to replicate another one previously
			baseenum=enums[i]; 		
			/*is the baseenum repeated later on?:*/
			for(j=i+1;j<maxfields;j++){
				if (enums[j]==baseenum)enums[j]=-1;
			}
		}
		else continue;
	}

	/*Now, go through enums, and whatever is not null is a non repeated field name: */
	nfields=0;
	for(i=0;i<maxfields;i++)if(enums[i]>0)nfields++;

	/*Add 1 field for time: */
	nfields++;
	
	/*Fill the names of the structure field: */
	fnames=(const char**)xmalloc(nfields*sizeof(char*));
	count=0;
	for(i=0;i<maxfields;i++){
		if (enums[i]>0){
			fnames[count]=EnumAsString(enums[i]);
			count++;
		}
	}
	/*don't forget the extra field "time":*/
	fnames[nfields-1]=EnumAsString(TimeEnum);

	/*Initialize structure: */
	dataref=mxCreateStructArray( ndim,onebyone,nfields,fnames);

	/*Fill each field: */
	for(i=0;i<results->Size();i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);
		result->SetMatlabField(dataref);
	}
	
	/*Assign output pointers:*/
	*pdataref=dataref;

}
#endif
