/*\file OutputResults.c
 *\brief: output results inside elements, and in femmodel
 */

#include "./OutputResults.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	Elements* elements=NULL;
	Nodes*   nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	DataSet* results=NULL;
	
	/* output datasets: */
	mxArray* dataref=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&OutputResultsUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&results,RESULTS);

	/*results might be NILL, allocate: */
	if(!results)results=new Results(ResultsEnum);

	/*Call "x" code layer: */
	OutputResultsx(&dataref, elements,nodes,vertices,loads,materials,parameters,results);

	/*write output datasets: */
	plhs[0]=dataref;
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete results;

	/*end module: */
	MODULEEND();
}

void OutputResultsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [results] = %s(elements,nodes,vertices,loads,materials,parameters,results);\n",__FUNCT__);
	_printf_("\n");
}
