function md=transient3d(md);
%
%   Usage:
%      md=transient3d(md)
%
%   See also: TRANSIENT2D, TRANSIENT

	%timing
	t1=clock;

	numanalyses=9;
	analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticStokesAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];
	solution_type=Transient3DSolutionEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=transient3d_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.transient3d=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);

	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel,femmodel.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
