/*
 * CreateNodesSurfaceSlope.c:
 */

#include "../../../Container/Container.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesSurfaceSlope(Nodes** pnodes, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);
	
	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements, iomodel->my_vertices, iomodel->my_bordervertices, iomodel, iomodel_handle,continuous_galerkin);
	
	/*First fetch data: */
	if (iomodel->dim==3){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");

	for (i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,SurfaceSlopeAnalysisEnum));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	
	/*Assign output pointer: */
	*pnodes=nodes;
}
