#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#Some functions 
function today_date {
suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'` 
echo $suffix;
}

#create ISSM variables
OLDISSM_DIR=$ISSM_DIR;
export ISSM_DIR="/home/morlighe/Ice/issm/trunk/cron/issm/trunk"
ISSM_RELEASE="issm";

#Figure out today's date
today=`today_date`;
host_name=`hostname`;

#Erase code
rm -rf $ISSM_RELEASE

#Fetch svn code
svn checkout file:///u/wilkes-r1b/larour/Repository/issm

source $ISSM_DIR/etc/environment.sh

#Go to the issm directory
cd $ISSM_DIR

#install ISSM

#1: install some packages
cd externalpackages
cd mpich2
sh install.sh
cd ../petsc
sh install.sh
cd ../metis
sh install.sh
cd ../triangle
sh install.sh
cd $ISSM_DIR

#2: install automake and autoconf
cd devpackages
make
cd ..

#3: generate MakeFiles
./reconfigure.sh
./configure.sh

#4: compile ISSM
make
make install

#Figure out mailing list
source cron/mailinglist

#Launch matlab and the nightly run script
matlab -nodisplay  > ./nightly.log << EOF 
startup
nightlyrun;
EOF

#Process log for errors 
cat nightly.log | grep ERROR > errors1.log
cat nightly.log | grep SUCCESS > errors2.log
cat errors1.log errors2.log > errors.log
		
#Mail
ERRORS=`cat errors.log`
if [ `expr length "$ERRORS"`  = "0" ]; then
	for i in `echo $MAILINGLIST`
		do
			mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today. DID NOT WORK CORRECTLY" $i < nightly.log
		done
else
	for i in `echo $MAILINGLIST`
		do  
			mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today." $i < errors.log
		done
fi

#Erase log and error logs
rm -rf nightly.log errors1.log errors2.log errors.log

#Erase ice code
cd ..
rm -rf $ISSM_RELEASE

#back to old ISSM_DIR
ISSM_DIR=$OLDISSM_DIR
export ISSM_DIR
