function md=transient2d(md);
%TRANSIENT2D - 2d transient solution
%
%   Usage:
%      md=transient(md)
%
%   See also: TRANSIENT3D, TRANSIENT

	%timing
	t1=clock;

	numanalyses=2;
	analyses=[DiagnosticHorizAnalysisEnum;PrognosticAnalysisEnum];
	solution_type=Transient2DSolutionEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analyses,numanalyses);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=transient2d_core(femmodel);
		
		displaystring(verbose,'%s',['write results']);
		md.results.transient2d=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);

	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel,femmodel.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
