function md=balancedvelocities(md)
%BALANCEDVELOCITIES - balancedvelocities solution sequence.
%
%   Usage:
%      md=balancedvelocities(md)

	%timing
	t1=clock;

	numanalyses=1;
	analyses=[BalancedvelocitiesAnalysisEnum];
	solution_type=BalancedvelocitiesSolutionEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analyses,1);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=balancedvelocities_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.balancedvelocities=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
