function md=balancedthickness2(md)
%BALANCEDTHICKNESS - balancedthickness2 solution sequence.
%
%   Usage:
%      md=balancedthickness2(md)

	%timing
	t1=clock;

	numanalyses=1;
	analyses=[Balancedthickness2AnalysisEnum];
	solution_type=Balancedthickness2SolutionEnum;

	displaystring(md.verbose,'%s',['create finite element model']);
	femmodel=NewFemModel(md,solution_type,analyses,1);

	%retrieve parameters
	verbose=femmodel.parameters.Verbose;
	qmu_analysis=femmodel.parameters.QmuAnalysis;

	%compute solution
	if ~qmu_analysis,
		displaystring(verbose,'%s',['call computational core']);
		femmodel=balancedthickness2_core(femmodel);

		displaystring(verbose,'%s',['write results']);
		md.results.balancedthickness2=OutputResults(femmodel.elements, femmodel.nodes , femmodel.vertices , femmodel.loads , femmodel.materials, femmodel.parameters, femmodel.results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(femmodel);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
