function tolerance=testsgettolerance(md,sequence,field),
%TESTSGETTOLERANCE - give the tolerance for the nightly run 
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   It gives the accepted tolerance, given the package, the analysis_type and the field check.
%
%   Usage:
%      tolerance=testsgettolerance(md,sequence,field);
%
%   See also: RUNME

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if ~parallel,
	tolerance=10^-12;

else
	if (analysis_type==BalancedthicknessSolutionEnum),
		tolerance=10^-14;

	elseif (analysis_type==BedSlopeSolutionEnum),
		tolerance=10^-14;

	elseif (analysis_type==SurfaceSlopeSolutionEnum),
		tolerance=10^-14;

	elseif (analysis_type==PrognosticSolutionEnum),
		tolerance=10^-14;

	elseif (analysis_type==Prognostic2SolutionEnum),
		tolerance=10^-14;

	elseif (analysis_type==Transient2DSolutionEnum),
		tolerance=10^-11;

	elseif (analysis_type==Transient3DSolutionEnum),
		if md.isstokes,
			tolerance=10^-4;
		elseif any(md.gridonpattyn),
			tolerance=10^-6;
		else,
			tolerance=10^-12;
		end

	elseif (analysis_type==DiagnosticSolutionEnum),
		if md.isstokes,
			tolerance=10^-4;
		elseif any(md.gridonpattyn),
			tolerance=10^-6;
		elseif ~isnans(md.rifts),
			tolerance=10^-10;
		else,
			tolerance=10^-13;
		end

	elseif (analysis_type==ThermalSolutionEnum),
		if strncmpi(fliplr(field),fliplr('melting'),7),
			tolerance=10^-6;
		elseif strncmpi(fliplr(field),fliplr('temperature'),11),
			tolerance=10^-11;
		end

	elseif (analysis_type==SteadystateSolutionEnum),
			if md.isstokes | md.control_analysis,
				tolerance=5*10^-4;
			elseif any(md.gridonpattyn),
				tolerance=2*10^-8;
			else,
				tolerance=10^-10;
			end

	else
		error(['testsgettolerance error message: analysis_type '  analysis_type ' not supported yet with package parallel solution']);
	end
end
